close all;
clear all;
clc;

% Load data
Naghshband = importdata('nagh_data.txt');
wl2014_22 = importdata('2014.wl.ep18.cu125.85.60.txt');
usOws2014_22_borg = importdata('Piena2014_final_ep18cu125_85_60_Diet_01_usws.txt');
Fr2014_22_borg = importdata('Piena2014_final_ep18cu125_85_60_Diet_01_Fr.txt');
usOws2014_22_ser = importdata('Piena2014_final_ep18cu125_85_60_Diet_02_usws.txt');
Fr2014_22_ser = importdata('Piena2014_final_ep18cu125_85_60_Diet_02_Fr.txt');
usOws2014_22_fi = importdata('Piena2014_final_ep18cu125_85_60_Diet_03_usws.txt');
Fr2014_22_fi = importdata('Piena2014_final_ep18cu125_85_60_Diet_03_Fr.txt');
usOws2014_22_lg = importdata('Piena2014_final_ep18cu125_85_60_Diet_04_usws.txt');
Fr2014_22_lg = importdata('Piena2014_final_ep18cu125_85_60_Diet_04_Fr.txt');
usOws2014_22_pl = importdata('Piena2014_final_ep18cu125_85_60_Diet_05_usws.txt');
Fr2014_22_pl = importdata('Piena2014_final_ep18cu125_85_60_Diet_05_Fr.txt');

% Define the output directory
outputDir = fullfile('C:', 'Users', 'Admin', 'Desktop', 'PD paper', 'Analysis', 'outpts');
if ~exist(outputDir, 'dir')
    mkdir(outputDir); % Create the directory if it doesn't exist
end

% Define file paths for video and GIF
videoFileName = fullfile(outputDir, 'new_animation_with_heatmap_wschange__Jimenez.mp4');
gifFileName = fullfile(outputDir, 'new_animation_with_heatmap_wschange__Jimenez.gif');

disp(['Saving video to: ', videoFileName]);
disp(['Saving GIF to: ', gifFileName]);

% Define the figure
figure;
set(gcf, 'Position', [100, 100, 1200, 800]); % Fix figure size to ensure consistent frame dimensions

% Set up video writer
try
    v = VideoWriter(videoFileName, 'MPEG-4');
    v.FrameRate = 20; % Adjust frame rate
    open(v);  % Open the video file for writing
catch
    error('VideoWriter failed to initialize. Please check the file path and permissions.');
end


colorRange = [0, 10];  % Adjusted color range from 0 to 10
% Animation loop
for j = 2:size(usOws2014_22_borg, 1)
    clf;  % Clear figure for each frame
    subplot(3, 2, 1);
    % Extract data for the current frame
    x = usOws2014_22_borg(j, :); % X-coordinates
    y = Fr2014_22_borg(j, :);    % Y-coordinates
    
    % Remove NaN values (important for density estimation)
    validIdx = ~isnan(x) & ~isnan(y);
    x = x(validIdx);
    y = y(validIdx);
    
    % Define grid for KDE
    xGrid = linspace(0, 5, 100);
    yGrid = linspace(0, 1.5, 100);
    [XGrid, YGrid] = meshgrid(xGrid, yGrid);
    
    % Perform 2D Kernel Density Estimation
    data = [x(:), y(:)];
    [f, xi] = ksdensity(data, [XGrid(:), YGrid(:)]); % KDE on the grid points
    
    % Reshape KDE results into grid form
    fGrid = reshape(f, size(XGrid));
    
    % Interpolate density values at data points
    density = griddata(XGrid, YGrid, fGrid, x, y, 'cubic');
    
    % Normalize density values for color mapping
    densityNorm= (density - min(density)) / (max(density) - min(density));
    
% Sort data by density
[sortedDensity, sortIdx] = sort(densityNorm, 'ascend'); % Sort by ascending density
xSorted = x(sortIdx);
ySorted = y(sortIdx);

% Create scatter plot with colors based on sorted density
scatter(xSorted, ySorted, 20, sortedDensity, 'filled'); % 20 is marker size


    % Create scatter plot with colors based on density
    % % scatter(x, y, 20, densityNorm, 'filled'); % 20 is marker size
      colormap(hot); % Choose your preferred colormap
    % % colormap([linspace(1, 1, 256)', linspace(1, 0, 256)', linspace(1, 0, 256)']);
    % colorbar; % Add colorbar
    caxis([0, 1]); % Set color axis range
    set(gca, 'YDir', 'normal', 'Color', 'k'); % Set background to black
    title(sprintf('Borgoforte'));
    xlabel('X');
    ylabel('Y');
    xlim([0, 5]);
    ylim([0, 1]);


        hold on;
    plot(Naghshband(:, 5), Naghshband(:, 6), 'LineStyle', '--', 'Color', 'w', 'LineWidth', 0.6);
    xlim([0, 5]);
    ylim([0, 1]);
    xlabel('U_*/w_s');
    ylabel('Fr');

    hold on
    % Add box with extra plots
    inset_ax = axes('Position', [0.3404, 0.8424, 0.119028193686994, 0.076]); % Position for inset box (top-right)
    plot(wl2014_22(:, 2), 'w-'); % Full dataset
    hold on;
    plot(j, wl2014_22(j, 2), 'w.', 'MarkerSize', 20); % Current value
    set(inset_ax, 'Box', 'on', 'XTick', [], 'YTick', [], 'Color','k','XColor','w','YColor','w'); % Make it look like a box
    ylabel('Water Level','FontSize',8, 'Color','w')
    xlabel('Time (h)','FontSize',8, 'Color','w')
    ylim([12 26]);





     subplot(3, 2, 2);
    x = usOws2014_22_ser(j, :);
    y = Fr2014_22_ser(j, :);
    validIdx = ~isnan(x) & ~isnan(y);
    x = x(validIdx);
    y = y(validIdx);
    xGrid = linspace(0, 5, 100);
    yGrid = linspace(0, 1.5, 100);
    [XGrid, YGrid] = meshgrid(xGrid, yGrid);
    data = [x(:), y(:)];
    [f, xi] = ksdensity(data, [XGrid(:), YGrid(:)]);
    fGrid = reshape(f, size(XGrid));
    density = griddata(XGrid, YGrid, fGrid, x, y, 'cubic');
    densityNorm = (density - min(density)) / (max(density) - min(density));
[sortedDensity, sortIdx] = sort(densityNorm, 'ascend'); % Sort by ascending density
xSorted = x(sortIdx);
ySorted = y(sortIdx);
scatter(xSorted, ySorted, 20, sortedDensity, 'filled'); % 20 is marker size
    % colormap(hot);
    % colorbar;
    caxis([0, 1]);
    set(gca, 'YDir', 'normal', 'Color', 'k');
    title(sprintf('Sermide'));
    xlabel('X');
    ylabel('Y');
    xlim([0, 5]);
    ylim([0, 1]);
        hold on;
    plot(Naghshband(:, 5), Naghshband(:, 6), 'LineStyle', '--', 'Color', 'w', 'LineWidth', 0.6);
    xlim([0, 5]);
    ylim([0, 1]);
    xlabel('U_*/w_s');
    ylabel('Fr');
        hold on
    % Add box with extra plots
    inset_ax = axes('Position', [0.7791, 0.8424, 0.119028193686994, 0.076]); % Position for inset box (top-right)
    plot(wl2014_22(:, 3), 'w-'); % Full dataset
    hold on;
    plot(j, wl2014_22(j, 3), 'w.', 'MarkerSize', 20); % Current value
     set(inset_ax, 'Box', 'on', 'XTick', [], 'YTick', [], 'Color','k','XColor','w','YColor','w'); % Make it look like a box
    ylabel('Water Level','FontSize',8, 'Color','w')
    xlabel('Time (h)','FontSize',8, 'Color','w')
    ylim([6 18]);




     subplot(3, 2, 3);
    x = usOws2014_22_fi(j, :);
    y = Fr2014_22_fi(j, :);
    validIdx = ~isnan(x) & ~isnan(y);
    x = x(validIdx);
    y = y(validIdx);
    xGrid = linspace(0, 5, 100);
    yGrid = linspace(0, 1.5, 100);
    [XGrid, YGrid] = meshgrid(xGrid, yGrid);
    data = [x(:), y(:)];
    [f, xi] = ksdensity(data, [XGrid(:), YGrid(:)]);
    fGrid = reshape(f, size(XGrid));
    density = griddata(XGrid, YGrid, fGrid, x, y, 'cubic');
    densityNorm = (density - min(density)) / (max(density) - min(density));
[sortedDensity, sortIdx] = sort(densityNorm, 'ascend'); % Sort by ascending density
xSorted = x(sortIdx);
ySorted = y(sortIdx);
scatter(xSorted, ySorted, 20, sortedDensity, 'filled'); % 20 is marker size
    % colormap(hot);
    % colorbar;
    caxis([0, 1]);
    set(gca, 'YDir', 'normal', 'Color', 'k');
    title(sprintf('Ficarolo'));
    xlabel('X');
    ylabel('Y');
    xlim([0, 5]);
    ylim([0, 1]);
        hold on;
    plot(Naghshband(:, 5), Naghshband(:, 6), 'LineStyle', '--', 'Color', 'w', 'LineWidth', 0.6);
    xlim([0, 5]);
    ylim([0, 1]);
    xlabel('U_*/w_s');
    ylabel('Fr');
        hold on
    % Add box with extra plots
    inset_ax = axes('Position', [0.3404, 0.5421, 0.119028193686994, 0.076]); % Position for inset box (top-right)
    plot(wl2014_22(:, 4), 'w-'); % Full dataset
    hold on;
    plot(j, wl2014_22(j, 4), 'w.', 'MarkerSize', 20); % Current value
    set(inset_ax, 'Box', 'on', 'XTick', [], 'YTick', [], 'Color','k','XColor','w','YColor','w'); % Make it look like a box
    ylabel('Water Level','FontSize',8, 'Color','w')
    xlabel('Time (h)','FontSize',8, 'Color','w')
    ylim([4 16]);




     subplot(3, 2, 4);
    x = usOws2014_22_fi(j, :);
    y = Fr2014_22_fi(j, :);
    validIdx = ~isnan(x) & ~isnan(y);
    x = x(validIdx);
    y = y(validIdx);
    xGrid = linspace(0, 5, 100);
    yGrid = linspace(0, 1.5, 100);
    [XGrid, YGrid] = meshgrid(xGrid, yGrid);
    data = [x(:), y(:)];
    [f, xi] = ksdensity(data, [XGrid(:), YGrid(:)]);
    fGrid = reshape(f, size(XGrid));
    density = griddata(XGrid, YGrid, fGrid, x, y, 'cubic');
    densityNorm = (density - min(density)) / (max(density) - min(density));
[sortedDensity, sortIdx] = sort(densityNorm, 'ascend'); % Sort by ascending density
xSorted = x(sortIdx);
ySorted = y(sortIdx);
scatter(xSorted, ySorted, 20, sortedDensity, 'filled'); % 20 is marker size
    % colormap(hot);
    % colorbar;
    caxis([0, 1]);
    set(gca, 'YDir', 'normal', 'Color', 'k');
    title(sprintf('Pontelagoscuro'));
    xlabel('X');
    ylabel('Y');
    xlim([0, 5]);
    ylim([0, 1]);
        hold on;
    plot(Naghshband(:, 5), Naghshband(:, 6), 'LineStyle', '--', 'Color', 'w', 'LineWidth', 0.6);
    xlim([0, 5]);
    ylim([0, 1]);
    xlabel('U_*/w_s');
    ylabel('Fr');
        hold on
    % Add box with extra plots
    inset_ax = axes('Position', [0.7791, 0.5421, 0.119028193686994, 0.076]); % Position for inset box (top-right)
    plot(wl2014_22(:, 5), 'w-'); % Full dataset
    hold on;
    plot(j, wl2014_22(j, 5), 'w.', 'MarkerSize', 20); % Current value
     set(inset_ax, 'Box', 'on', 'XTick', [], 'YTick', [], 'Color','k','XColor','w','YColor','w'); % Make it look like a box
    ylabel('Water Level','FontSize',8, 'Color','w')
    xlabel('Time (h)','FontSize',8, 'Color','w')
    ylim([2 14]);




     subplot(3, 2, 5);
    x = usOws2014_22_fi(j, :);
    y = Fr2014_22_fi(j, :);
    validIdx = ~isnan(x) & ~isnan(y);
    x = x(validIdx);
    y = y(validIdx);
    xGrid = linspace(0, 5, 100);
    yGrid = linspace(0, 1.5, 100);
    [XGrid, YGrid] = meshgrid(xGrid, yGrid);
    data = [x(:), y(:)];
    [f, xi] = ksdensity(data, [XGrid(:), YGrid(:)]);
    fGrid = reshape(f, size(XGrid));
    density = griddata(XGrid, YGrid, fGrid, x, y, 'cubic');
    densityNorm = (density - min(density)) / (max(density) - min(density));
[sortedDensity, sortIdx] = sort(densityNorm, 'ascend'); % Sort by ascending density
xSorted = x(sortIdx);
ySorted = y(sortIdx);
scatter(xSorted, ySorted, 20, sortedDensity, 'filled'); % 20 is marker size
    % colormap(hot);
    % colorbar;
    caxis([0, 1]);
    set(gca, 'YDir', 'normal', 'Color', 'k');
    title(sprintf('Polesella'));
    xlabel('X');
    ylabel('Y');
    xlim([0, 5]);
    ylim([0, 1]);
        hold on;
    plot(Naghshband(:, 5), Naghshband(:, 6), 'LineStyle', '--', 'Color', 'w', 'LineWidth', 0.6);
    xlim([0, 5]);
    ylim([0, 1]);
    xlabel('U_*/w_s');
    ylabel('Fr');
        hold on
    % Add box with extra plots
    inset_ax = axes('Position', [0.3404, 0.2409, 0.119028193686994, 0.076]); % Position for inset box (top-right)
    plot(wl2014_22(:, 6), 'w-'); % Full dataset
    hold on;
    plot(j, wl2014_22(j, 6), 'w.', 'MarkerSize', 20); % Current value
     set(inset_ax, 'Box', 'on', 'XTick', [], 'YTick', [], 'Color','k','XColor','w','YColor','w'); % Make it look like a box
    ylabel('Water Level','FontSize',8, 'Color','w')
    xlabel('Time (h)','FontSize',8, 'Color','w')
    ylim([0 12]);




 
    % Capture the current frame for video
    frame = getframe(gcf); % Capture the entire figure
    writeVideo(v, frame);  % Write the frame to the video

    % Capture the frame for GIF
    im = frame2im(frame); % Convert frame to image
    [imind, cm] = rgb2ind(im, 256); % Convert to indexed image
    if j == 2
        imwrite(imind, cm, gifFileName, 'gif', 'Loopcount', inf, 'DelayTime', 0.05);
    else
        imwrite(imind, cm, gifFileName, 'gif', 'WriteMode', 'append', 'DelayTime', 0.05);
    end

    % Pause for animation effect
    pause(0.05);
end

% Close video writer
close(v);  % Ensure the video is finalized and saved
disp(['Video saved as ', videoFileName]);
disp(['GIF saved as ', gifFileName]);
