%% This code reads the modelled salt marsh mean inundation depth  under OPEN, MOSE, and ATHOS scenarios
clearvars
close all
clc
%% Year 2020
% Load .mat files
load  MID_OPEN_2020.mat
load  MID_MOSE_2020.mat
load MID_ATHOS_2020.mat

% Plot boxplot 
figure()
boxplot([MID_OPEN_2020 MID_MOSE_2020 MID_ATHOS_2020], 'Labels', {'OPEN', 'MOSE', 'ATHOS'})
ylim([-0.05 0.8])
ylabel('Mean Inundation Depth (m)')
title('MID 2020')
%% Year 2021
% Load .mat files
load  MID_OPEN_2021.mat
load  MID_MOSE_2021.mat
load MID_ATHOS_2021.mat

% Plot boxplot 
figure()
boxplot([MID_OPEN_2021 MID_MOSE_2021 MID_ATHOS_2021], 'Labels', {'OPEN', 'MOSE', 'ATHOS'})
ylim([-0.05 0.8])
ylabel('Mean Inundation Depth (m)')
title('MID 2021')
%% Year 2022
% Load .mat files
load  MID_OPEN_2022.mat
load  MID_MOSE_2022.mat
load MID_ATHOS_2022.mat

% Plot boxplot 
figure()
boxplot([MID_OPEN_2022 MID_MOSE_2022 MID_ATHOS_2022], 'Labels', {'OPEN', 'MOSE', 'ATHOS'})
ylim([-0.05 0.8])
ylabel('Mean Inundation Depth (m)')
title('MID 2022')
%% Year 2023
% Load .mat files
load  MID_OPEN_2023.mat
load  MID_MOSE_2023.mat
load MID_ATHOS_2023.mat

% Plot boxplot 
figure()
boxplot([MID_OPEN_2023 MID_MOSE_2023 MID_ATHOS_2023], 'Labels', {'OPEN', 'MOSE', 'ATHOS'})
ylim([-0.05 0.8])
ylabel('Mean Inundation Depth (m)')
title('MID 2023')
